/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.tags.hmc;

import com.ibm.hwmca.fw.servlet.tags.hmc.PieChartHandler;
import com.ibm.hwmca.fw.util.Trace;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagSupport;

public class PieSliceHandler
extends TagSupport {
    private static final String TRACE_MASK = "XTAGPIE";
    private static final String TRACE_MASKD = "XTAGPIED";
    private static final String TRACE_MASKF = "XTAGPIEF";
    private static final String TRACE_MASKT = "XTAGPIET";
    private double percentage;
    private int color;

    public int doStartTag() {
        Tag parentTag = this.getParent();
        if (!(parentTag instanceof PieChartHandler)) {
            throw new IllegalArgumentException("hmc:pieSlice must be nested within a hmc:pieChart tag");
        }
        ((PieChartHandler)parentTag).addSlice(this.percentage, this.color);
        return 1;
    }

    public int doEndTag() {
        return 6;
    }

    public void setPercentage(String percentageString) {
        Trace.trace(TRACE_MASKT, "-> setPercentage(" + percentageString + ")");
        if (percentageString == null || percentageString.equals("")) {
            throw new IllegalArgumentException("percentageString argument must be non-null & non-empty");
        }
        try {
            this.percentage = Double.parseDouble(percentageString.trim());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("percentageString argument must be a double value: " + percentageString);
        }
        if (this.percentage < 0.0) {
            throw new IllegalArgumentException("percentageString must be greater than 0: " + this.percentage);
        }
        Trace.trace(TRACE_MASKT, "<- setPercentage(" + percentageString + ")");
    }

    public void setColor(String colorString) {
        Trace.trace(TRACE_MASKT, "-> setColor(" + colorString + ")");
        if (colorString == null || colorString.equals("")) {
            throw new IllegalArgumentException("colorString argument must be non-null & non-empty");
        }
        try {
            this.color = Integer.decode(colorString.trim());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("colorString argument must be an integer value: " + colorString);
        }
        if (this.color < 0) {
            throw new IllegalArgumentException("color must be greater than or equal to 0: " + this.color);
        }
        Trace.trace(TRACE_MASKT, "<- setColor(" + colorString + ")");
    }
}

